<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Messages', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Explicitly set InnoDB for foreign keys
            $table->bigIncrements('Message_id');
            $table->unsignedBigInteger('Sender_id');
            $table->unsignedBigInteger('Receiver_id');
            $table->text('Content');
            $table->boolean('Is_read')->default(false);
            $table->timestamp('Sent_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->foreign('Sender_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->foreign('Receiver_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->index(['Sender_id', 'Receiver_id'], 'Idx_sender_receiver');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('Messages');
    }
};
